#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Sphere Project- BoomboxMod01.fsh  by   tiff  
//https://www.shadertoy.com/view/4lKyWG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Sphere - Signed Distance Function
float sphere(vec3 p, float radius){
    return length(p)-radius;
}


// Locate objects
float map(vec3 p)
{    
    // Sphere radius
    float sphereSize = 0.6;
    
    // Transform coordinate space so spheres repeat
    vec3 q = fract(p) * 2.0 - 1.1;
    
    int tx = int(q.y);
    float fft  = texelFetch( texture0, ivec2(tx,0), 0 ).x; 
	fft *= 1.0;
    
    // Signed distance of sphere
    float s = sphere(abs(tan(q)), sphereSize);
    float d = 0.08 * (cos(q.x*10.*fft)*cos(q.y*10.*fft) * tan(q.z*10.*fft)  );
    //return s +wave;
    return s+d;
}


// Trace rays
float trace(vec3 origin, vec3 r) 
{
  float t = 0.0; // Distance Traveled
    for (int i = 0; i < 5; ++i) {
        vec3 p = origin + r * t;
        float d = map(p); // Locate object
        t += d * 0.8; // Step along the ray
    }
    return tan(t); //tan inverses shadows
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    vec3 color = 0.5 + 0.5*cos(iTime+uv.xyx+vec3(0,2,4));
    
    uv = uv *2.-1.; // Remap the space to -1. to 1.
    uv.x *= iResolution.x/iResolution.y;

   	// Create ray to fire into scene
   	vec3 ray = normalize(vec3(uv, 1.5));
    
    // Create origin of scene
    vec3 origin = vec3(0., 0.,iTime); //iTime changes z perspective, going into screen
   
    
    // Trace any objects in the scene
    float t = trace(origin, ray);
    
    // Generate fog based on distance from t
    float fog = 1.0 / (1.0 + t * t * 0.1);
    
    // Final color with includes sdf + fog
    vec3 fc = vec3(fog);


    //fc -= abs(log(tan(color))); //different transitioning of color   
    fc -= tan(color);
    
    // Output to screen
    fragColor = vec4(fc, color);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

